<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslatableInterface;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\UuidInterface;
use Ramsey\Uuid\Uuid;
use CpCreation\VitiCore\Product\Repository\ProductTypeOptionRepository;
use CpCreation\VitiCore\Product\Model\ProductType;

/**
 * Class ProductTypeOption
 * 
 * @ORM\Entity(repositoryClass="ProductTypeOptionRepository")
 * @ORM\Table(name="product_option")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductTypeOption implements HasTranslatable
{
    use Translatable;

    /**
     * @Assert\Valid
     * @AcmeAssert\Translation()
     * @ORM\OneToMany(targetEntity="CpCreation\VitiCore\Product\Model\Translation\ProductTypeOptionTranslation", mappedBy="translatable", cascade={"persist","remove","merge"}, indexBy="locale", orphanRemoval="true")
     *
     * @var TranslationInterface[]|Collection
     */
    protected $translations;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     * @var UuidInterface
     */
    private UuidInterface $id;

    /**
     * @var int
     */
    private int $multiple;

    /**
     * @var Product
     * @ORM\ManyToOne(targetEntity="ProductType",inversedBy="options")
     */
    private Product $productType;

    public function __construct(){
        $this->id = Uuid::uuid4();
    }

    /**
     * @return Uuid
     */
    public function getId(): Uuid
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getMultiple(): int
    {
        return $this->multiple;
    }

    /**
     * @param int $multiple
     */
    public function setMultiple(int $multiple): void
    {
        $this->multiple = $multiple;
    }
}