<?php

namespace CpCreation\VitiCore\Cart\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Cart
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Cart\Repository\InvoiceRepository")
 * @ORM\Table(name="cart_invoice")
 * @ORM\HasLifecycleCallbacks()
 */
class Invoice implements HasTimestamp
{

    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private ?UuidInterface $id = null;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer|null
     */
    private ?int $numberDebit = null;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer|null
     */
    private ?int $numberCredit = null;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var integer|null
     */
    private ?int $year = null;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     *
     * @var bool
     */
    private bool $credit = false;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTime|null
     */
    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTime $creditAt = null;

    /**
     * @ORM\OneToOne(targetEntity="Cart", mappedBy="invoice")
     *
     * @var Cart|null
     */
    private ?Cart $cart;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->year = $this->createYear();
    }

    public function getId(): ?UuidInterface
    {
        return $this->id;
    }

    public function getNumberDebit(): int
    {
        return $this->numberDebit;
    }

    public function setNumberDebit(?int $numberDebit): void
    {
        $this->numberDebit = $numberDebit;
    }

    public function getNumberCredit(): ?int
    {
        return $this->numberCredit;
    }

    public function setNumberCredit(?int $numberCredit): void
    {
        $this->numberCredit = $numberCredit;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function isCredit(): bool
    {
        return $this->credit;
    }

    public function setCredit(bool $credit): void
    {
        $this->credit = $credit;
    }

    public function getCreditAt(): ?\DateTime
    {
        return $this->creditAt;
    }

    public function setCreditAt(?\DateTime $creditAt): void
    {
        $this->creditAt = $creditAt;
    }

    private function createYear(): int
    {
        $date = new \DateTime();

        return intval($date->format('Y'));
    }

    public function getCart(): ?Cart
    {
        return $this->cart;
    }


}