<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Shop\Model\ShopConfigDisableCountry;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShopConfigDisableCountryType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('country', CountryType::class, [
                'label'    => 'Choisir un pays',
                'required' => true,
            ])
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'required' => false,
                    'fields' => [
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Texte à afficher lorsque la boutique est bloqué pour ce pays',
                            'help'       => 'Si aucun texte, le texte par défaut sera utilisé',
                            'required'   => false,
                        ],
                    ],
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShopConfigDisableCountry::class,
            ]
        );
    }
}
