<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Library\Model\Library;
use CpCreation\VitiCore\Library\Model\LibraryImages;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class LibraryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'title' => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => false,
                        ],
                        'legend' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Légende',
                            'required'   => false,
                        ]
                    ],
                    'excluded_fields' => ['slug']
                ]
            )
            ->add(
                'image', ImageType::class, [
                    'label'          => 'Image',
                     'required'   => true
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Library::class
            ]
        );
    }
}