<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ProductTypeType;
use CpCreation\VitiCore\Product\Model\ProductCategory;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN')")
 * Class ProductTypeController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/product-type")
 */
class ProductTypeController extends AbstractController
{
    private $productTypeRepository;

    public function __construct(ProductTypeRepository $productTypeRepository)
    {
        $this->productTypeRepository =  $productTypeRepository;
    }

    /**
     * @route("", name="admin_product_type")
     */
    public function indexAction()
    {
        $productTypes = $this->productTypeRepository->findByPositionOrderAdmin();


        return $this->render('admin/product/type/index.html.twig', [
            "items" => $productTypes,
        ]);

    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_product_type_new")
     *
     * 
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ProductTypeType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductType $data */
            $data = $form->getData();
            $this->productTypeRepository->save($data);
            $this->addFlash('alert-success', 'Le type '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_product_type');

        }

        return $this->render('admin/product/type/new.html.twig', [
            "form" => $form->createView(),
        ]);
    }

    /**
     * @param ProductType $type
     * @param Request $request
     * @Route("/{id}/edit", name="admin_product_type_edit")
     *
     * 
     */
    public function editAction(ProductType $type, Request $request)
    {
        $form = $this->createForm(ProductTypeType::class, $type);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductType $data */
            $data = $form->getData();
            $this->productTypeRepository->save($data);
            $this->addFlash('alert-success', 'Le type '.$type->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_product_type');

        }

        return $this->render('admin/product/type/edit.html.twig', [
            "item" => $type,
            "form" => $form->createView(),
        ]);

    }

    /**
     * @param ProductType $type
     * @Route("/{id}/moveUp", name="admin_product_type_move_up")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveUpAction(ProductType $type)
    {
        $type->setPosition($type->getPosition() - 1);
        $this->productTypeRepository->save($type);
        $this->addFlash('alert-success', 'La type de produit '.$type->getName().' a été remonté.');

        return $this->redirectToRoute('admin_product_type');
    }

    /**
     * @param ProductType $type
     * @Route("/{id}/moveDown", name="admin_product_type_move_down")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveDownAction(ProductType $type)
    {
        $type->setPosition($type->getPosition() + 1);
        $this->productTypeRepository->save($type);
        $this->addFlash('alert-success', 'Le type de produit '.$type->getName().' a été descendu.');

        return $this->redirectToRoute('admin_product_type');
    }

    /**
     * @param ProductType $type
     * @Route("/{id}/delete", name="admin_product_type_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ProductType $type)
    {
        $this->productTypeRepository->delete($type);
        $this->addFlash('alert-success', 'Le type '.$type->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_product_type');
    }
}
