<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ProductPriceCodeType;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_PRICE_CODE')")
 * Class ProductPriceCodeController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/product-price-code")
 */
class ProductPriceCodeController extends AbstractController
{
    private $productPriceCodeRepository;

    public function __construct(ProductPriceCodeRepository $productPriceCodeRepository)
    {
        $this->productPriceCodeRepository = $productPriceCodeRepository;
    }

    /**
     * @route("", name="admin_product_price_code")
     */
    public function indexAction()
    {
        $codes = $this->productPriceCodeRepository->findByGroupOrderAdmin();

        return $this->render('admin/product/price/code/index.html.twig', [
            "items" => $codes
        ]);
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_product_price_code_new")
     *
     * 
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ProductPriceCodeType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductPriceCode $data */
            $data = $form->getData();
            $this->productPriceCodeRepository->save($data);
            $this->addFlash('alert-success', 'Le code '.$data->getCode().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_product_price_code');

        }

        return $this->render('admin/product/price/code/new.html.twig', [
            "form" => $form->createView(),
        ]);
    }

    /**
     * @param ProductPriceCode $code
     * @param Request $request
     * @Route("/{id}/edit", name="admin_product_price_code_edit")
     *
     * 
     */
    public function editAction(ProductPriceCode $code, Request $request)
    {
        $form = $this->createForm(ProductPriceCodeType::class, $code);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductPriceCode $data */
            $data = $form->getData();
            $this->productPriceCodeRepository->save($data);
            $this->addFlash('alert-success', 'Le code '.$code->getCode().' a été modifié avec succès');

            return $this->redirectToRoute('admin_product_price_code');

        }

        return $this->render('admin/product/price/code/edit.html.twig', [
            "item" => $code,
            "form" => $form->createView(),
        ]);
    }

    /**
     * @param ProductPriceCode $code
     * @Route("/{id}/delete", name="admin_product_price_code_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ProductPriceCode $code)
    {
        $this->productPriceCodeRepository->softDelete($code);
        $this->addFlash('alert-success', 'Le code '.$code->getCode().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_product_price_code');
    }

}
