<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;
use CpCreation\VitiCore\Media\Model\Video as ModelVideo;

trait Video
{
    /**
     * @ORM\OneToOne(targetEntity="CpCreation\VitiCore\Media\Model\Video", cascade={"persist", "remove"})
     * @var ModelVideo
     */
    private $video;

    /**
     * @return ModelVideo|null
     */
    public function getVideo(): ?ModelVideo
    {
        return $this->video;
    }

    /**
     * @param ModelVideo|null $video
     */
    public function setVideo(ModelVideo $video = null)
    {
        $this->video = $video;
    }
}
