<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;

/**
 * Class ShopConfigTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="shop_config_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class ShopConfigTranslation
{
    use Translation;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string|null
     */
    private $favoriteCatName;

    /**
     * @return string|null
     */
    public function getFavoriteCatName(): ?string
    {
        return $this->favoriteCatName;
    }

    /**
     * @param string|null $favoriteCatName
     */
    public function setFavoriteCatName(?string $favoriteCatName): void
    {
        $this->favoriteCatName = $favoriteCatName;
    }
}
