<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;

/**
 * Class ShippingConfigTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="shop_shipping_config_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingConfigTranslation
{
    use Translation;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string
     */
    private $shippingText;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $shippingInfo;

    /**
     * @return string
     */
    public function getShippingText(): ?string
    {
        return $this->shippingText;
    }

    /**
     * @param string $shippingText
     */
    public function setShippingText(string $shippingText = null): void
    {
        $this->shippingText = $shippingText;
    }

    /**
     * @return string
     */
    public function getShippingInfo(): ?string
    {
        return $this->shippingInfo;
    }

    /**
     * @param string $shippingInfo
     */
    public function setShippingInfo(string $shippingInfo = null)
    {
        $this->shippingInfo = $shippingInfo;
    }
}
