<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShopConfig
 *
 * @ORM\Table(name="shop_shop_config")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShopConfigRepository")
 */
class ShopConfig implements HasTimestamp, HasTranslatable
{
    use Translatable, Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $viewCategory;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $viewOrderByCategory;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $hidePriceDefault;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $enableAwardShop;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $viewFavoriteCat;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $disableLogoBank;

    /**
     * @ORM\Column(type="json", nullable=true, options={"default" : "[]"})
     *
     * @var array|null
     */
    private $disableCountriesForShop;

    /**
     * @ORM\Column(type="json", nullable=true, options={"default" : "[]"})
     *
     * @var array|null
     */
    private $enableCountriesForShop;

    /**
     * @Assert\Type(type="integer")
     *
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int|null
     */
    private $maxAwardsVisibleInShop;

    public function __construct()
    {
        $this->id                      = Uuid::uuid4();
        $this->viewCategory            = 1;
        $this->hidePriceDefault        = 0;
        $this->enableAwardShop         = false;
        $this->disableLogoBank         = false;
        $this->disableCountriesForShop = [];
        $this->enableCountriesForShop  = [];
        $this->viewOrderByCategory     = false;
        $this->viewFavoriteCat         = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return bool
     */
    public function isViewCategory(): bool
    {
        return $this->viewCategory;
    }

    /**
     * @param bool $viewCategory
     */
    public function setViewCategory(bool $viewCategory): void
    {
        $this->viewCategory = $viewCategory;
    }

    /**
     * @return bool
     */
    public function isViewOrderByCategory(): bool
    {
        return $this->viewOrderByCategory;
    }

    /**
     * @param bool $viewOrderByCategory
     */
    public function setViewOrderByCategory(bool $viewOrderByCategory): void
    {
        $this->viewOrderByCategory = $viewOrderByCategory;
    }

    /**
     * @return bool
     */
    public function isDisableLogoBank(): bool
    {
        return $this->disableLogoBank;
    }

    /**
     * @param bool $disableLogoBank
     */
    public function setDisableLogoBank(bool $disableLogoBank): void
    {
        $this->disableLogoBank = $disableLogoBank;
    }

    /**
     * @return bool
     */
    public function isHidePriceDefault(): bool
    {
        return $this->hidePriceDefault;
    }

    /**
     * @param bool $hidePriceDefault
     */
    public function setHidePriceDefault(bool $hidePriceDefault): void
    {
        $this->hidePriceDefault = $hidePriceDefault;
    }

    /**
     * @return bool
     */
    public function isEnableAwardShop(): bool
    {
        return $this->enableAwardShop;
    }

    /**
     * @param bool $enableAwardShop
     */
    public function setEnableAwardShop(bool $enableAwardShop): void
    {
        $this->enableAwardShop = $enableAwardShop;
    }

    /**
     * @return bool
     */
    public function isViewFavoriteCat(): bool
    {
        return $this->viewFavoriteCat;
    }

    /**
     * @param bool $viewFavoriteCat
     */
    public function setViewFavoriteCat(bool $viewFavoriteCat): void
    {
        $this->viewFavoriteCat = $viewFavoriteCat;
    }

    /**
     * @return array|null
     */
    public function getDisableCountriesForShop(): ?array
    {
        return $this->disableCountriesForShop;
    }

    /**
     * @param array|null $disableCountriesForShop
     */
    public function setDisableCountriesForShop(?array $disableCountriesForShop): void
    {
        $this->disableCountriesForShop = $disableCountriesForShop;
    }

    /**
     * @return array|null
     */
    public function getEnableCountriesForShop(): ?array
    {
        return $this->enableCountriesForShop;
    }

    /**
     * @param array|null $enableCountriesForShop
     */
    public function setEnableCountriesForShop(?array $enableCountriesForShop): void
    {
        $this->enableCountriesForShop = $enableCountriesForShop;
    }

    /**
     * @return int|null
     */
    public function getMaxAwardsVisibleInShop(): ?int
    {
        return $this->maxAwardsVisibleInShop;
    }

    /**
     * @param int|null $maxAwardsVisibleInShop
     */
    public function setMaxAwardsVisibleInShop(?int $maxAwardsVisibleInShop): void
    {
        $this->maxAwardsVisibleInShop = $maxAwardsVisibleInShop;
    }
}
