<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Repository;

use CpCreation\VitiCore\Product\Model\ProductCategory;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ProductCategoryRepository extends BaseRepository
{
    /**
     * ProductCategoryRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductCategory::class);
    }

    public function findOnlyShop(ProductPriceGroup $groupPrice = null)
    {
        $qb = $this->createQueryBuilder('cat')
                   ->addSelect('tr')
                   ->addSelect('pr')
                   ->innerJoin('cat.translations', 'tr', Join::WITH, 'tr.translatable = cat.id')
                   ->join('cat.products', 'pr', Join::WITH, 'pr.category = cat.id')
                   ->andWhere('pr.shop = TRUE' )
                   ->andWhere('cat.pageShop = TRUE' )
                   ->orderBy('cat.position', 'ASC');
        if ($groupPrice)
        {
            $qb->innerJoin('pr.groups', 'gr', Join::WITH, 'gr.id = :group')
            ->setParameter('group', $groupPrice->getId()->toString());
        }

        return $qb->getQuery()->getResult();

    }
}
