<?php

/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Popup\Model;

use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Image;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Popup
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Popup\Repository\PopupRepository")
 * @ORM\Table(name="popup_popup")
 * @ORM\HasLifecycleCallbacks()
 */
class Popup implements HasImage, HasTimestamp, HasTranslatable
{

    use Image, Timestamp, Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     * @Assert\NotBlank()
     * @var \DateTime
     */
    private $unPublishedAt;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     * @Assert\NotBlank()
     * @var \DateTime
     */
    private $publishedAt;


    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return \DateTime
     */
    public function getUnPublishedAt(): ?\DateTime
    {
        return $this->unPublishedAt;
    }

    /**
     * @param \DateTime $unPublishedAt
     */
    public function setUnPublishedAt(\DateTime $unPublishedAt = null)
    {
        $this->unPublishedAt = $unPublishedAt;
    }

    /**
     * @return \DateTime
     */
    public function getPublishedAt(): ?\DateTime
    {
        return $this->publishedAt;
    }

    /**
     * @param \DateTime $publishedAt
     */
    public function setPublishedAt(\DateTime $publishedAt = null)
    {
        $this->publishedAt = $publishedAt;
    }
}