<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Newsletter\Model;

use CpCreation\VitiCore\Behavior\HasFile;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\File;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Ramsey\Uuid\Uuid;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Newsletter
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Newsletter\Repository\NewsletterRepository")
 * @ORM\Table(name="newsletter_newsletter")
 * @ORM\HasLifecycleCallbacks()
 */
class Newsletter implements HasTimestamp, HasTranslatable, HasFile
{

    use Timestamp, Translatable, File;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @Assert\Callback
     */
    public function validate(ExecutionContextInterface $context, $payload)
    {
        if (!$this->getFile()) {
            $context->buildViolation('Vous devez ajouter un fichier')
                    ->atPath('file.file')
                    ->addViolation();
        }
    }
}