<?php
/**
 * @author Colinet Julien
 */
namespace CpCreation\VitiCore\Depot\Repository;

use CpCreation\VitiCore\Depot\Model\Depot;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class DepotRepository extends BaseRepository
{
    /**
     * DepotRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Depot::class);
    }

    public function findByCategory($slug)
    {
        $qb = $this
            ->createQueryBuilder('depot')
            ->innerJoin('depot.translations', 'tr', Join::WITH, 'tr.translatable = depot.id')
            ->innerJoin('depot.category', 'ca', Join::WITH, 'ca.id = depot.category')
            ->innerJoin('ca.translations', 'catr', Join::WITH, 'catr.translatable = ca.id')
            ->andWhere('catr.slug = :slug')
            ->orderBy('depot.postal', 'ASC')
            ->setParameter('slug', $slug)
            ->getQuery();

        return $qb->execute();
    }

    public function findByCategoryOrderName($slug)
    {
        $qb = $this
            ->createQueryBuilder('depot')
            ->innerJoin('depot.translations', 'tr', Join::WITH, 'tr.translatable = depot.id')
            ->innerJoin('depot.category', 'ca', Join::WITH, 'ca.id = depot.category')
            ->innerJoin('ca.translations', 'catr', Join::WITH, 'catr.translatable = ca.id')
            ->andWhere('catr.slug = :slug')
            ->orderBy('tr.name', 'ASC')
            ->setParameter('slug', $slug)
            ->getQuery();

        return $qb->execute();
    }

    public function findAllOrderByCountryOrderByCategoryOrderPostalAll()
    {
        $qb = $this
            ->createQueryBuilder('depot')
            ->leftJoin('depot.translations', 'tr', Join::WITH, 'tr.translatable = depot.id')
            ->leftJoin('depot.category', 'ca')
            ->leftJoin('ca.translations', 'catr', Join::WITH, 'catr.translatable = ca.id')
            ->addOrderBy('depot.country', 'ASC')
            ->addOrderBy('catr.slug', 'ASC')
            ->addOrderBy('depot.postal', 'ASC')
            ->getQuery();

        return $qb->execute();
    }
}