<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Contact\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class LabelTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="contact_label_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class LabelTranslation
{
    use Translation;

    /**
     * @var string
     * @ORM\Column(type="text", nullable=true)
     *
     */
    private $text;

    /**
     * @return string
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string $text
     */
    public function setText(string $text = null): void
    {
        $this->text = $text;
    }
}
