<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model\Payment;

use Symfony\Component\Validator\Constraints as Assert;

class Monetico
{
    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @Assert\NotBlank()
     *
     * @var bool
     */
    private $production;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $hmacKey;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $eptNumber;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $version;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $companyCode;

    public function __construct()
    {
        $this->version = "3.0";
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return bool
     */
    public function isProduction(): ?bool
    {
        return $this->production;
    }

    /**
     * @param bool $production
     */
    public function setProduction(bool $production)
    {
        $this->production = $production;
    }

    /**
     * @return string
     */
    public function getHmacKey(): ?string
    {
        return $this->hmacKey;
    }

    /**
     * @param string $hmacKey
     */
    public function setHmacKey(string $hmacKey)
    {
        $this->hmacKey = $hmacKey;
    }

    /**
     * @return string
     */
    public function getEptNumber(): ?string
    {
        return $this->eptNumber;
    }

    /**
     * @param string $eptNumber
     */
    public function setEptNumber(string $eptNumber)
    {
        $this->eptNumber = $eptNumber;
    }

    /**
     * @return string
     */
    public function getVersion(): ?string
    {
        return $this->version;
    }

    /**
     * @param string $version
     */
    public function setVersion(string $version)
    {
        $this->version = $version;
    }

    /**
     * @return string
     */
    public function getCompanyCode(): ?string
    {
        return $this->companyCode;
    }

    /**
     * @param string $companyCode
     */
    public function setCompanyCode(string $companyCode)
    {
        $this->companyCode = $companyCode;
    }

}