<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Intl\Countries;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class DeliveryAddress
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Cart\Repository\DeliveryAddressRepository")
 * @ORM\Table(name="cart_delivery_address")
 * @ORM\HasLifecycleCallbacks()
 */
class DeliveryAddress
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $lastname;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $firstname;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $street;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $postalCode;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $city;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $country;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Email()
     *
     * @var string
     */
    private $email;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Assert\Regex(pattern="/^[0-9\-\(\)\/\+\s]*$/", message="error.phone")
     *
     * @var string
     */
    private $phone;

    /**
     * @ORM\Column(type="boolean", options={"default" : 0})
     *
     * @var boolean
     */
    private $differentAddress = 0;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname(?string $lastname)
    {
        $this->lastname = $lastname;
    }

    /**
     * @return string
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname(?string $firstname)
    {
        $this->firstname = $firstname;
    }

    /**
     * @return string
     */
    public function getStreet(): ?string
    {
        return $this->street;
    }

    /**
     * @param string $street
     */
    public function setStreet(?string $street)
    {
        $this->street = $street;
    }

    /**
     * @return string
     */
    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    /**
     * @param string $postalCode
     */
    public function setPostalCode(?string $postalCode)
    {
        $this->postalCode = $postalCode;
    }

    /**
     * @return string
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @param string $city
     */
    public function setCity(?string $city)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email = null): void
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     */
    public function setPhone(string $phone = null): void
    {
        $this->phone = $phone;
    }

    /**
     * @return string
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(?string $country)
    {
        $this->country = $country;
    }

    /**
     * @return bool
     */
    public function isDifferentAddress(): bool
    {
        return $this->differentAddress;
    }

    /**
     * @param bool $differentAddress
     */
    public function setDifferentAddress(bool $differentAddress)
    {
        $this->differentAddress = $differentAddress;
    }

    public function getCountryName(): ?string
    {
        if (!$this->getCountry()) {
            return null;
        }

        return Countries::getName($this->getCountry());
    }
}
