<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Product\Model\ProductDegressive;
use CpCreation\VitiCore\Product\Model\ProductPrice;
use CpCreation\VitiCore\Product\Repository\ProductDegressiveRepository;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class CalculDegressive
{
    private $productDegressiveRepository;
    private $productTypeRepository;
    private $request;
    private $session;

    public function __construct(
        ProductDegressiveRepository $productDegressiveRepository,
        ProductTypeRepository $productTypeRepository,
        RequestStack $request,
        SessionInterface $session
    ) {
        $this->productDegressiveRepository = $productDegressiveRepository;
        $this->productTypeRepository       = $productTypeRepository;
        $this->request                     = $request;
        $this->session                     = $session;
    }

    /**
     * @param Cart $cart
     * @return float|int|null
     * @throws \Doctrine\ORM\NonUniqueResultException
     * @throws \Exception
     */
    public function calcul(Cart $cart)
    {
        $degressiveTotal  = 0;
        $totalAmount      = 0;
        $items            = $cart->getItems();
        $equivalencyQty   = 0;
        $allPricesVariant = [];
        $priceGroupId     = $this->session->get("groupPrice", null);
        $types            = [];
        /** @var CartItem $item */
        foreach ($items as $item) {
            $id = $item->getVariant()->getType()->getId()->toString();
            if (isset($types[$id])) {
                $types[$id] = $types[$id] + $item->getQuantity();
            } else {
                $types[$id] = $item->getQuantity();
            }
            //Calcul total
            /** @var ProductPrice $price */
            foreach ($item->getVariant()->getPrices() as $price) {
                if ($price->getGroup()->getId()->toString() === $priceGroupId) {
                    if ($price->getPriceDiscount()) {
                        array_push($allPricesVariant, $price->getPriceDiscount());
                        $totalAmount = $totalAmount + ($price->getPriceDiscount() * $item->getQuantity());
                    } else {
                        array_push($allPricesVariant, $price->getPrice());
                        $totalAmount = $totalAmount + ($price->getPrice() * $item->getQuantity());
                    }
                }
            }
            $minPriceVariant = min($allPricesVariant);
            $equivalencyQty  = $equivalencyQty + ($item->getVariant()->getType()->getEquivalencyFreeShipping() * $item->getQuantity());
        }

        $typeDefault = $this->productTypeRepository->findDefaultType();
        /** @var ProductDegressive $degressiveByEquivalency */
        $degressiveByEquivalency = $this->productDegressiveRepository->findByQuantityAndByTypeAndByGroupAndByEquivalency($equivalencyQty, $typeDefault->getId()->toString(), $cart, $priceGroupId);

        if ($degressiveByEquivalency) {
            $equivalencyQty = $cart->getQuantityByProducts($degressiveByEquivalency->getProducts());
            if ($degressiveByEquivalency->getBottlePrice() || $degressiveByEquivalency->getPackagePrice()) {
                if ($degressiveByEquivalency->getBottlePrice()) {
                    if ($degressiveByEquivalency->isAllQuantity()) {
                        $degressiveTotal = $degressiveTotal + $degressiveByEquivalency->getBottlePrice() * $equivalencyQty;
                    } else {
                        $degressiveTotal = $degressiveTotal + $degressiveByEquivalency->getBottlePrice() * ($equivalencyQty - $degressiveByEquivalency->getQtyOf());
                    }
                } else {
                    $degressiveTotal = $degressiveTotal + $degressiveByEquivalency->getPackagePrice();
                }
            }
            if ($degressiveByEquivalency->getPackagePercent()) {
                $degressiveTotal = $degressiveTotal + ($totalAmount * $degressiveByEquivalency->getPackagePercent());
            }
            if ($degressiveByEquivalency->getQtyOfBottleOffered()) {
                $numberBottleOffered = (floor($equivalencyQty / ($degressiveByEquivalency->getQtyOf() + 1)) * $degressiveByEquivalency->getQtyOfBottleOffered());
                $degressiveTotal     = $degressiveTotal + ($minPriceVariant * $numberBottleOffered);
            }
        } else {
            foreach ($types as $key => $quantity) {
                /** @var ProductDegressive $degressive */
                $degressive = $this->productDegressiveRepository->findByQuantityAndByTypeAndByGroup($quantity, $key, $cart, $priceGroupId);
                if ($degressive) {
                    if ($degressive->getBottlePrice() || $degressive->getPackagePrice()) {
                        if ($degressive->getBottlePrice()) {
                            if ($degressive->isAllQuantity()) {
                                $degressiveTotal = $degressiveTotal + $degressive->getBottlePrice() *  $quantity;
                            } else {
                                $degressiveTotal = $degressiveTotal + $degressive->getBottlePrice() * ( $quantity - $degressive->getQtyOf());
                            }
                        } else {
                            $degressiveTotal = $degressiveTotal + $degressive->getPackagePrice();
                        }
                    }
                    if ($degressive->getPackagePercent()) {
                        $degressiveTotal = $degressiveTotal + ($totalAmount * $degressive->getPackagePercent());
                    }
                    if ($degressive->getQtyOfBottleOffered()) {
                        $numberBottleOffered = (floor( $quantity / ($degressive->getQtyOf() + 1)) * $degressive->getQtyOfBottleOffered());
                        $degressiveTotal     = $degressiveTotal + ($minPriceVariant * $numberBottleOffered);
                    }
                }
            }
        }

        if ($degressiveTotal > 0) {
            return $degressiveTotal;
        }

        return null;
    }
}
