<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Twig;

use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use Symfony\Component\Intl\Countries;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class AppExtension extends AbstractExtension
{
    private $productPriceGroupRepository;
    private $productPriceCodeRepository;
    private $shippingCountryRepository;

    public function __construct(ProductPriceGroupRepository $productPriceGroupRepository, ProductPriceCodeRepository $productPriceCodeRepository, ShippingCountryRepository $shippingCountryRepository)
    {
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productPriceCodeRepository = $productPriceCodeRepository;
        $this->shippingCountryRepository = $shippingCountryRepository;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('countriesShippingByGroup', [$this, 'countriesShippingByGroup']),
        ];
    }

    public function countriesShippingByGroup($string, $groupId)
    {
        $group = $this->productPriceGroupRepository->find($groupId);

        $countries = $this->shippingCountryRepository->findCountriesAssignedByGroup($group->getId()->toString());
        /** @var ShippingCountry $country */
        $countriesWithZone = [];
        foreach ($countries as $country) {
            $countriesWithZone[] = Countries::getName($country->getCode());
        }

        return str_replace("%countries%", implode(", ", $countriesWithZone), $string);
    }
}
