<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Service;

class EncryptOpenSSl
{
    const METHOD    = "AES-256-CBC";
    const SECRETKEY = "viti-core";
    const SECRETIV  = "123456";

    /**
     * @param string $string
     * @return string
     */
    public function encrypt(string $string)
    {
        $output = openssl_encrypt($string, self::METHOD, $this->createKey(), 0, $this->createIv());

        return base64_encode($output);
    }

    /**
     * @param string $string
     * @return string
     */
    public function decrypt(string $string)
    {
        return openssl_decrypt(base64_decode($string), self::METHOD, $this->createKey(), 0, $this->createIv());
    }

    private function createKey()
    {
        return hash('sha256', self::SECRETKEY);
    }

    private function createIv()
    {
        return substr(hash('sha256', self::SECRETIV), 0, 16);
    }
}
