<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider;

use A2lix\TranslationFormBundle\Locale\LocaleProviderInterface;
use CpCreation\VitiCore\Locale\Repository\LocaleRepository;

class LocaleProvider implements LocaleProviderInterface
{
    const DEFAULT = 'fr';
    private $locales;

    public function __construct(LocaleRepository $localeRepository)
    {
        $this->locales = [self::DEFAULT];
        $locales = $localeRepository->findBy(['disabled' => 0]);
        foreach ($locales as $locale)
        {
            array_push($this->locales, $locale->getLocale());
        }
    }

    public function getLocales(): array
    {
        return $this->locales;
    }

    public function getDefaultLocale(): string
    {
        return 'fr';
    }

    public function getRequiredLocales(): array
    {
        return $this->locales;
    }
}