<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site;

use CpCreation\VitiCore\Cart\Model\InvoiceAddress;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TelType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class InvoiceAddressType extends AbstractType
{

    private $countriesWithZone;

    public function __construct(
        ShippingCountryRepository $shippingCountryRepository,
        SessionInterface $session
    ) {
        $group                   = $session->get("groupPrice");
        $countries               = $shippingCountryRepository->findCountriesAssignedByGroup($group);
        $this->countriesWithZone = [];
        /** @var ShippingCountry $country */
        foreach ($countries as $country) {
            $this->countriesWithZone[$country->getCode()] = $country->getCode();
        }

    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'company', TextType::class, [
                    'label'    => 'shop.form.company',
                    'attr'     => [
                        'placeholder'  => 'shop.form.company',
                        'autocomplete' => 'organization',
                    ],
                    'required' => false,
                ]
            )
            ->add(
                'tvaNumber', TextType::class, [
                    'label'    => 'shop.form.tva',
                    'attr'     => [
                        'placeholder'  => 'shop.form.tva',
                        'autocomplete' => 'nope',
                    ],
                    'required' => false,
                ]
            )
            ->add(
                'lastname', TextType::class, [
                    'label'    => 'shop.form.lastname',
                    'attr'     => [
                        'placeholder'  => 'shop.form.lastname',
                        'autocomplete' => 'family-name',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'firstname', TextType::class, [
                    'label'    => 'shop.form.firstname',
                    'attr'     => [
                        'placeholder'  => 'shop.form.firstname',
                        'autocomplete' => 'name',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'street', TextType::class, [
                    'label'    => 'shop.form.address',
                    'attr'     => [
                        'placeholder'  => 'shop.form.address',
                        'autocomplete' => 'nope',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'postalCode', TextType::class, [
                    'label'    => 'shop.form.postal_code',
                    'attr'     => [
                        'placeholder'  => 'shop.form.postal_code',
                        'autocomplete' => 'nope',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'city', TextType::class, [
                    'label'    => 'shop.form.city',
                    'attr'     => [
                        'placeholder'  => 'shop.form.city',
                        'autocomplete' => 'nope',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'country', CountryType::class, [
                    'label'             => 'shop.form.country',
                    'required'          => true,
                    'preferred_choices' => $this->countriesWithZone,
                    'attr'              => [
                        'separator'    => '=====',
                        'autocomplete' => 'nope',
                    ],
                ]
            )
            ->add(
                'email', EmailType::class, [
                    'label'    => 'shop.form.email',
                    'attr'     => [
                        'placeholder'  => 'shop.form.email',
                        'autocomplete' => 'email',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'phone', TelType::class, [
                    'label'    => 'shop.form.phone',
                    'attr'     => [
                        'placeholder'  => 'shop.form.phone',
                        'autocomplete' => 'tel',
                    ],
                    'required' => true,
                ]
            );
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            [$this, 'onPreSetData']
        );

    }

    public function onPreSetData(FormEvent $event)
    {
        $form = $event->getForm();
        $data = $event->getData();
        if (!$data) {
            $form->remove('country');

            $form->add(
                'country', CountryType::class, [
                    'label'             => 'shop.form.country',
                    'required'          => true,
                    'preferred_choices' => $this->countriesWithZone,
                    'data'              => 'FR',
                    'attr'              => [
                        'separator'    => '=====',
                        'autocomplete' => 'nope',
                    ],
                ]
            );

        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => InvoiceAddress::class,
            ]
        );
    }
}
