<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\SocialNetwork\Model\SocialNetwork;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SocialNetworkStep1Type extends AbstractType
{
    /**
     * @var array
     */
    private $choices;

    public function __construct($socialNetworkMethods)
    {
        foreach ($socialNetworkMethods as $method)
        {
            $this->choices[$method] = $method;
        }
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('network', ChoiceType::class, [
                'choices' => $this->choices,
                'label' => 'Choisir un réseau social',
                'placeholder' => 'Aucun'
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => SocialNetwork::class
        ]);
    }

    public function getBlockPrefix() {
        return 'socialNetworkStep1';
    }

}