<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use Craue\FormFlowBundle\Form\FormFlow;
use Craue\FormFlowBundle\Form\FormFlowInterface;

class SocialNetworkFlow extends FormFlow
{
    protected function loadStepsConfig()
    {
        return [
            [
                'label'        => 'Network',
                'form_type'    => 'CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetworkStep1Type',
                'form_options' => [
                    'validation_groups' => ['step1'],
                ],
                'skip'         => function ($estimatedCurrentStepNumber, FormFlowInterface $flow) {

                    return $flow->getFormData()->getNetwork() !== null;
                },
            ],
            [
                'label'        => 'Config',
                'form_type'    => 'CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetworkStep2Type',
                'form_options' => [
                    'validation_groups' => ['step2'],
                ],
            ],
            [
                'label'        => 'Associer Facebook / Instagram',
                'form_type'    => 'CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetworkStep3Type',
                'form_options' => [
                    'validation_groups' => ['step3'],
                ],
                'skip'         => function ($estimatedCurrentStepNumber, FormFlowInterface $flow) {
                    if ($flow->getFormData()->getNetwork() == 'facebook_facebook' || $flow->getFormData()->getNetwork() == 'facebook_instagram') {
                        return false;
                    }

                    return true;
                },
            ],
        ];
    }
}
