<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\DataTransformer\TransformDateAtToIntAdditional;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\DataTransformer\TransformDateOfToIntAdditional;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\ShippingAdditional;
use CpCreation\VitiCore\Shop\Model\ShippingCounty;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShippingAdditionalType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('qtyOf', IntegerType::class, ['label' => 'De (>)', 'required' => true])
            ->add('qtyAt', IntegerType::class, ['label' => 'A (<=)', 'required' => true])
            ->add('dateOf', DateTimeType::class, [
                'required' => false,
                'label'    => 'Début de la période pour prise en compte du supplément',
                'input'    => 'datetime',
                'format'   => 'yyyy-MM-dd',
                'widget'   => 'single_text',
                'attr'     => [
                    'class' => 'datetimepicker',

                ],
            ])
            ->add('dateAt', DateTimeType::class, [
                'required' => false,
                'label'    => 'Fin de la période pour prise en compte du supplément',
                'input'    => 'datetime',
                'format'   => 'yyyy-MM-dd',
                'widget'   => 'single_text',
                'attr'     => [
                    'class' => 'datetimepicker',

                ],
            ])
            ->add(
                'counties', EntityType::class,
                [
                    'class' => 'CpCreation\VitiCore\Shop\Model\ShippingCounty',
                    'label'    => 'Département (2 chiffres)',
                    'multiple' => true,
                    'choice_label' => function ($county) {
                        /** @var ShippingCounty $county */
                        return $county->getCode();
                    },
                    'choice_value' => "code",
                    'attr'     => [
                        "class" => "select2-tag",
                    ],
                    'required' => false,
                ]
            )
            ->add(
                'groups', EntityType::class,
                [
                    'class'        => ProductPriceGroup::class,
                    'query_builder' => function (ProductPriceGroupRepository $er) {
                        return $er->findByNameOrderAdminQuery();
                    },
                    'choice_label' => 'name',
                    'label'        => 'Groupes de prix',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'price', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Supplément € (HT, car utilisable en auto)',
                    'required' => true,
                ]
            );
        $builder->get('dateOf')
                ->addModelTransformer(new TransformDateOfToIntAdditional());
        $builder->get('dateAt')
                ->addModelTransformer(new TransformDateAtToIntAdditional());
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShippingAdditional::class,
            ]
        );
    }
}
