<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Cart\Model\Promo;
use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\DeliveryMethodCategory;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PromoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, ['label' => 'Code promo', 'required' => true])
            ->add(
                'minEquivalency', IntegerType::class, [
                    'required' => false,
                    'label'    => 'Quantité minimum de commande (équivalence bouteille)',
                ]
            )
            ->add(
                'percent', PercentType::class, [
                    'required' => false,
                    'label'    => 'Remise pourcentage sur le montant du panier',
                ]
            )
            ->add(
                'percentShippingCost', PercentType::class, [
                    'required' => false,
                    'label'    => 'Remise pourcentage sur le montant du transport',
                ]
            )
            ->add(
                'amount', MoneyType::class, [
                    'divisor'  => 100,
                    'required' => false,
                    'label'    => 'Remise en euros',
                ]
            )
            ->add(
                'maxCount', NumberType::class, [
                    'required' => false,
                    'html5'    => true,
                    'label'    => 'Limiter le nombre d\'utilisation de ce code (dans l\'absolue)',
                ]
            )
            ->add(
                'maxCountByCustomer', NumberType::class, [
                    'required' => false,
                    'html5'    => true,
                    'label'    => 'Limiter le nombre d\'utilisation de ce code par utilisateur',
                ]
            )
            ->add(
                'beginAt', DateTimeType::class, [
                    'required' => true,
                    'label'    => 'Date de début',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',
                    ],
                ]
            )
            ->add(
                'endAt', DateTimeType::class, [
                    'required' => true,
                    'label'    => 'Date de fin',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',
                    ],
                ]
            )
            ->add(
                'disabled', ChoiceType::class, [
                    'required' => true,
                    'label'    => 'Publier',
                    'choices'  => [
                        "Oui" => false,
                        "Non" => true,
                    ],
                ]
            )
            ->add(
                'auto', CheckboxType::class, [
                    'required' => false,
                    'label'    => 'Mode auto (pas besoin d\'entrer un code)',
                ]
            )
            ->add(
                'multipleByQuantity', CheckboxType::class, [
                    'required' => false,
                    'label'    => 'Multiplier la remise en fonction de la quantité (Quantité total / quantité minimum )',
                ]
            )
            ->add(
                'includeShippingFees', CheckboxType::class, [
                    'required' => false,
                    'label'    => 'Prendre en compte les frais de port',
                ]
            )
            ->add(
                'groups', EntityType::class,
                [
                    'class'        => ProductPriceGroup::class,
                    'query_builder' => function (ProductPriceGroupRepository $er) {
                        return $er->findByNameOrderAdminQuery();
                    },
                    'choice_label' => 'name',
                    'label'        => 'Groupes de prix',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'products', TranslatedEntityType::class, [
                    'label'                => 'Produit(s) associé(s) à la remise',
                    'class'                => Product::class,
                    'translation_property' => 'name',
                    'required'             => false,
                    'multiple'             => true,
                    'help'         => 'laisser vide pour prendre en compte tous les produits',
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
           ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Promo::class,
            ]
        );
    }
}
