<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class ProductPriceGroupType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'required' => true,
                'label'      => 'Nom du groupe'
            ])
            ->add('viewHT', CheckboxType::class, [
                'label'      => 'Afficher les prix en HT ?',
                'required' => false,

            ])
            ->add('freeShipping', CheckboxType::class, [
                'label'      => 'Franco de port ?',
                'required' => false,
            ])
            ->add('byDefault', CheckboxType::class, [
                'label'      => 'Par défaut',
                'required' => false,
            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ProductPriceGroup::class,
            ]
        );
    }
}
