<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;


use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\News\Model\Category;
use CpCreation\VitiCore\News\Model\News;
use CpCreation\VitiCore\News\Model\NewsImage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class NewsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'            => false,
                    'fields'           => [
                        'title'    => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => true,
                        ],
                        'title2'   => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre Facultatif',
                            'required'   => false,
                        ],
                        'text'     => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Texte',
                            'required'   => false,
                        ],
                        'moreInfo' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Information supplémentaire',
                            'required'   => false,
                        ],
                    ],
                    'required_locales' => ['fr'],
                    'excluded_fields'  => ['slug'],
                ]
            )
            ->add(
                'eventAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Date de l\'évenement',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',

                    ],
                ]
            )
            ->add(
                'publishedAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Publier automatiquement la news',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',

                    ],
                ]
            )
            ->add(
                'unPublishedAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Dépublier automatiquement la news',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',

                    ],
                ]
            )
            ->add(
                'author', TextType::class, [
                    'required' => false,
                    'label'    => 'Autheur',
                ]
            )
            ->add(
                'address', TextType::class, [
                    'required' => false,
                    'label'    => 'Adresse',
                ]
            )
            ->add(
                'postal', TextType::class, [
                    'required' => false,
                    'label'    => 'Code postal',
                ]
            )
            ->add(
                'city', TextType::class, [
                    'required' => false,
                    'label'    => 'Ville',
                ]
            )
            ->add(
                'country', CountryType::class, [
                    'label'    => 'Pays',
                    'required' => false,
                ]
            )
            ->add(
                'images', ImageCollectionType::class, [
                    'label'         => false,
                    'entry_type'    => NewsImageType::class,
                    'allow_add'     => true,
                    'allow_delete'  => true,
                    'prototype'     => true,
                    'by_reference'  => false,
                    'delete_empty'  => true,
                    'attr'          => [
                        'data-name-prefix' => 'Image',
                        'class'            => "image-collection",
                    ],
                    'entry_options' => [
                        'data_class' => NewsImage::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add(
                'video', VideoType::class, [
                    'label'    => 'Vidéo ( Numéro de la vidéo, ex : nFoT4Z-0HIQ )',
                    'required' => false,
                ]
            )
            ->add(
                'file', FileType::class, [
                    'label'    => 'Fiche a télécharger avec la news',
                    'required' => false,
                    'title'    => true,
                ]
            )
            ->add(
                'category', TranslatedEntityType::class,
                [
                    'class'       => Category::class,
                    'required'    => false,
                    'translation_property' => 'name',
                    'placeholder' => 'Choisir une catégorie',
                ]
            )
            ->add(
                'disabled', CheckboxType::class, ['label' => 'Dépublié', 'required' => false]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => News::class,
            ]
        );
    }
}
