<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Event\Model\Event;
use CpCreation\VitiCore\Event\Model\EventImage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EventType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'           => false,
                    'fields'          => [
                        'name'        => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => true,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Description',
                            'required'   => false,
                        ],
                        'fileTitle'   => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre du fichier',
                            'required'   => false,
                        ],
                        'urlTitle'    => [
                            'field_type' => TextType::class,
                            'label'      => 'Tire de l\'url',
                            'required'   => false,
                        ],
                    ],
                    'excluded_fields' => ['slug'],
                ]
            )
            ->add(
                'beginAt', DateTimeType::class, [
                    'required' => true,
                    'label'    => 'Date de début',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',
                    ],
                ]
            )
            ->add(
                'endAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Date de fin',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',
                    ],
                ]
            )
            ->add('address', TextType::class, ['label' => 'Adresse', 'required' => false])
            ->add('postal', TextType::class, ['label' => 'Code postal', 'required' => false])
            ->add('city', TextType::class, ['label' => 'Ville', 'required' => false])
            ->add(
                'country', CountryType::class, [
                    'label'    => 'Pays',
                    'preferred_choices' => ['FR','BE','DE','LU','CH','IT','ES'],
                    'required' => true,
                ]
            )
            ->add('url', TextType::class, ['label' => 'Url', 'required' => false])
            ->add(
                'file', FileType::class, ['label' => 'Fiche ', 'required' => false]
            )
            ->
            add(
                'images', ImageCollectionType::class, [
                    'label'          => false,
                    'entry_type'     => EventImageType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Image',
                        'class'            => "image-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => EventImage::class,
                        'label'      => false,
                    ],
                ]
            );

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Event::class,
            ]
        );
    }
}