<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use Liip\ImagineBundle\Imagine\Cache\CacheManager;
use Liip\ImagineBundle\Imagine\Data\DataManager;
use Liip\ImagineBundle\Imagine\Filter\FilterManager;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;

class ImagineController
{
    private $filterManager;

    private $cacheManager;

    private $dataManager;

    public function __construct(FilterManager $filterManager, CacheManager $cacheManager, DataManager $dataManager)
    {
        $this->filterManager = $filterManager;
        $this->cacheManager = $cacheManager;
        $this->dataManager = $dataManager;
    }


    public function filterSvgAction($path, $filter)
    {
        $binary = $this->dataManager->find($filter, $path);
        if ($binary->getMimeType() === 'image/svg') {
            $filteredBinary = $binary;
        } else {
            $filteredBinary = $this->filterManager->applyFilter($binary, $filter);
        }

        $this->cacheManager->store(
            $filteredBinary,
            $path,
            $filter
        );

        return new RedirectResponse($this->cacheManager->resolve($path, $filter), Response::HTTP_MOVED_PERMANENTLY);
    }
}