<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\History\Repository\HistoryRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class HomeController extends AbstractController
{
    private $historyRepository;
    public function __construct(HistoryRepository $historyRepository)
    {
        $this->historyRepository = $historyRepository;
    }

    /**
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $histories = $this->historyRepository->findBy(['disabled' => 0], ['position' => 'ASC']);

        return $this->render(
            'home.html.twig',
            [
                'classMenu' => 'black',
                "histories" => $histories,
                'subMenu'   => true,
            ]
        );
    }
}
