<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ShippingZoneType;
use CpCreation\VitiCore\Shop\Model\ShippingZone;
use CpCreation\VitiCore\Shop\Repository\ShippingZoneRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @IsGranted({"ROLE_ADMIN"})
 * Class ShippingZoneController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/shipping-zone")
 */
class ShippingZoneController extends AbstractController
{
    private $shippingZoneRepository;

    public function __construct(ShippingZoneRepository $shippingZoneRepository)
    {
        $this->shippingZoneRepository =  $shippingZoneRepository;
    }

    /**
     * @route("", name="admin_shipping_zone")
     * @Template("@CpCreationVitiCore/admin/shipping/zone/index.html.twig")
     */
    public function indexAction()
    {
        $zones = $this->shippingZoneRepository->findBy([], ["name" => 'ASC']);

        return [
            "items" => $zones,
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_shipping_zone_new")
     * @Template("@CpCreationVitiCore/admin/shipping/zone/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ShippingZoneType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingZone $data */
            $data = $form->getData();
            $this->shippingZoneRepository->save($data);
            $this->addFlash('alert-success', 'La zone '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_shipping_zone');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingZone $zone
     * @param Request $request
     * @Route("/{id}/edit", name="admin_shipping_zone_edit")
     * @Template("@CpCreationVitiCore/admin/shipping/zone/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ShippingZone $zone, Request $request)
    {
        $form = $this->createForm(ShippingZoneType::class, $zone);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingZone $data */
            $data = $form->getData();
            $this->shippingZoneRepository->save($data);
            $this->addFlash('alert-success', 'La zone '.$zone->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_shipping_zone');

        }

        return [
            "item" => $zone,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingZone $zone
     * @Route("/{id}/delete", name="admin_shipping_zone_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ShippingZone $zone)
    {
        $this->shippingZoneRepository->delete($zone);
        $this->addFlash('alert-success', 'Le produit '.$zone->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_shipping_zone');
    }
}
