<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\NewsCategoryType;
use CpCreation\VitiCore\News\Model\Category;
use CpCreation\VitiCore\News\Repository\CategoryRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;

/**
 * @IsGranted({"ROLE_ADMIN","ROLE_NEWS"})
 * Class NewsCategoryController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/categories_news")
 */
class NewsCategoryController extends AbstractController
{
    private $categoryRepository;

    public function __construct(CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * @route("", name="admin_news_category")
     * @Template("@CpCreationVitiCore/admin/news/category/index.html.twig")
     */
    public function listAllDepots()
    {
        $categories = $this->categoryRepository->findBy([], ['position' => 'ASC']);

        return [
            "items" => $categories,
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_news_category_new")
     * @Template("@CpCreationVitiCore/admin/news/category/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(NewsCategoryType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Category $data */
            $data = $form->getData();
            $this->categoryRepository->save($data);
            $this->addFlash('alert-success', 'La catégorie '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_news_category');
        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Category $category
     * @param Request  $request
     * @Route("/{id}/edit", name="admin_news_category_edit")
     * @Template("@CpCreationVitiCore/admin/news/category/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(Category $category, Request $request)
    {
        $form = $this->createForm(NewsCategoryType::class, $category);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Category $data */
            $data = $form->getData();
            $this->categoryRepository->save($data);
            $this->addFlash('alert-success', 'La categorie '.$category->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_news_category');
        }

        return [
            "item" => $category,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Category $category
     * @Route("/{id}/delete", name="admin_news_category_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(Category $category)
    {
        $this->categoryRepository->delete($category);
        $this->addFlash('alert-success', 'La catégorie '.$category->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_news_category');
    }

    /**
     * @param Category $category
     * @Route("/{id}/moveUp", name="admin_news_category_move_up")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveUpAction(Category $category)
    {
        $category->setPosition($category->getPosition() - 1);
        $this->categoryRepository->save($category);
        $this->addFlash('alert-success', 'La categorie '.$category->getName().' a été remonté.');

        return $this->redirectToRoute('admin_news_category');
    }

    /**
     * @param Category $category
     * @Route("/{id}/moveDown", name="admin_news_category_move_down")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveDownAction(Category $category)
    {
        $category->setPosition($category->getPosition() + 1);
        $this->categoryRepository->save($category);
        $this->addFlash('alert-success', 'La categorie '.$category->getName().' a été descendu.');

        return $this->redirectToRoute('admin_news_category');
    }
}
