<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\DepotType;
use CpCreation\VitiCore\Depot\Model\Depot;
use CpCreation\VitiCore\Depot\Repository\DepotRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;

/**
 * @IsGranted({"ROLE_DEPOT","ROLE_ADMIN"})
 * Class DepotController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/depots")
 */
class DepotController extends AbstractController
{
    private $depotRepository;

    public function __construct(DepotRepository $depotRepository)
    {
        $this->depotRepository = $depotRepository;
    }

    /**
     * @route("", name="admin_depot")
     * @Template("@CpCreationVitiCore/admin/depot/index.html.twig")
     */
    public function listAllDepots()
    {
        $depots = $this->depotRepository->findAllOrderByCountryOrderByCategoryOrderPostalAll();

        return [
            "items" => $depots,
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_depot_new")
     * @Template("@CpCreationVitiCore/admin/depot/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(DepotType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Depot $data */
            $data = $form->getData();
            $this->depotRepository->save($data);
            $this->addFlash('alert-success', 'Le dépôt '.$data->getName().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_depot');
        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Depot   $depot
     * @param Request $request
     * @Route("/{id}/edit", name="admin_depot_edit")
     * @Template("@CpCreationVitiCore/admin/depot/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(Depot $depot, Request $request)
    {
        $form = $this->createForm(DepotType::class, $depot);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Depot $data */
            $data = $form->getData();
            $this->depotRepository->save($data);
            $this->addFlash('alert-success', 'Le dépôt '.$depot->getName().' a été modifié avec succès');

            return $this->redirectToRoute('admin_depot');
        }

        return [
            "item" => $depot,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Depot $depot
     * @Route("/{id}/delete", name="admin_depot_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(Depot $depot)
    {
        $this->depotRepository->softDelete($depot);
        $this->addFlash('alert-success', 'Le dépôt '.$depot->getName().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_depot');
    }
}
