<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Doctrine\EventSubscriber;

use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Service\Uploader\ImageUploader;
use CpCreation\VitiCore\Media\Model\Image;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;

class ImageSubscriber implements EventSubscriber
{
    /**
     * @var ImageUploader
     */
    private $uploader;


    public function __construct(ImageUploader $uploader)
    {
        $this->uploader = $uploader;
    }

    public function getSubscribedEvents()
    {

        return [
            Events::prePersist,
            Events::postUpdate,
        ];
    }

    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if ($entity instanceof Image) {
            if ($entity->getFile()) {
                /** @var Image $image */
                $image = $this->uploader->upload($entity->getFile());
                $entity->setPath($image->getPath());
                $entity->setSize($image->getSize());
                $entity->setMimeType($image->getMimeType());
                $entity->setOriginalName($image->getOriginalName());
            }
        }
    }


    /**
     * @param LifecycleEventArgs $args
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function postUpdate(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if ($entity instanceof HasImage && $entity->getImage()) {
            if ($entity->getImage()->getFile()) {
                /** @var Image $image */
                $image = $this->uploader->upload($entity->getImage()->getFile());
                $entityManager = $args->getEntityManager();
                $entityManager->remove($entity->getImage());
                $entity->setImage($image);
                $entityManager->persist($entity);
                $entityManager->flush();
            }
        }
    }
}