<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\Common\Collections\ArrayCollection;
use Knp\DoctrineBehaviors\Model as ORMBehaviors;
use Symfony\Component\PropertyAccess\PropertyAccess;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Mapping\ClassMetadata;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Validator\Constraints as AcmeAssert;

trait Translatable
{

    use ORMBehaviors\Translatable\Translatable;

    /**
     * @Assert\Valid
     * @AcmeAssert\Translation()
     */
    protected $translations;

    public function getTranslations()
    {
        return $this->translations = $this->translations ?: new ArrayCollection();
    }

    public function getNewTranslations()
    {

        return $this->newTranslations = $this->newTranslations ?: new ArrayCollection();
    }

    public function __call($method, $arguments)
    {

        return PropertyAccess::createPropertyAccessor()->getValue($this->translate(), $method);
    }

    public static function getTranslationEntityClass()
    {
        $explodedNamespace = explode('\\', __CLASS__);
        $entityClass       = array_pop($explodedNamespace);

        return '\\'.implode('\\', $explodedNamespace).'\\Translation\\'.$entityClass.'Translation';
    }
}
