<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasDisable;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Disable;
use CpCreation\VitiCore\Behavior\Impl\SoftDeletable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ProductPriceCode
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository")
 * @ORM\Table(name="product_price_code")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductPriceCode implements HasTimestamp, IsSoftDeletable, HasDisable
{
    use Timestamp, SoftDeletable, Disable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="text", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $code;

    /**
     * @ORM\ManyToOne(targetEntity="ProductPriceGroup")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
     * @Assert\NotBlank()
     *
     * @var ProductPriceGroup
     */
    private $group;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
        $this->disabled = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code = null): void
    {
        $this->code = $code;
    }

    /**
     * @return ProductPriceGroup
     */
    public function getGroup(): ?ProductPriceGroup
    {
        return $this->group;
    }

    /**
     * @param ProductPriceGroup $group
     */
    public function setGroup(ProductPriceGroup $group = null): void
    {
        $this->group = $group;
    }

}
