<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Client\GeoClient;

class CheckCity
{
    private $client;

    public function __construct(GeoClient $client)
    {
        $this->client = $client;
    }

    public function check($city, $department, $postal = null, $loop = 0)
    {
        $split = explode(" ", $city);
        for ($i = $loop; $i <= 5; $i++) {
            $result = $this->loop($city, $split, $i);
            if (!$result) {
                return false;
            }
            $response = $this->call($result, $department, $postal);
            if ($response) {
                return strtoupper($this->strtoascii($response[0]->nom));
                break;
            }
        }

        return false;
    }

    private function call($city, $department, $postal)
    {
        $query = [
            'nom'             => $city
            /*'codeDepartement' => $department,*/
        ];
        if ($postal) {
            $query = array_merge($query, ["codePostal" => $postal]);
        }

        $request  = $this->client->get(
            "/communes", [
                'query' => $query,
            ]
        );
        $response = json_decode($request->getBody()->getContents());
        
        if (count($response) == 0) {
            return false;
        }

        return $response;
    }

    private function loop($city, $split, $loop)
    {
        if ($loop == 0) {
            return $city;
        } elseif ($loop == 1) {
            if (count($split) >= 5) {
                return $split[1]." ".$split[2]." ".$split[3]." ".$split[4];
            } elseif (count($split) >= 4) {
                return $split[1]." ".$split[3];
            } elseif (count($split) >= 3) {
                return $split[0]." ".$split[2];
            } elseif (count($split) >= 2) {
                return false;
            }
        } elseif ($loop == 2) {
            if (count($split) >= 5) {
                return $split[2]." ".$split[3]." ".$split[4];
            } elseif (count($split) >= 4) {
                return $split[2]." ".$split[3];
            } elseif (count($split) >= 3) {
                return $split[1]." ".$split[2];
            } elseif (count($split) >= 2) {
                return false;
            }
        } elseif ($loop == 3) {
            if (count($split) >= 5) {
                return $split[3]." ".$split[4];
            } elseif (count($split) >= 4) {
                return $split[0]." ".$split[2];
            } elseif (count($split) >= 3) {
                return $split[0]." ".$split[1];
            } elseif (count($split) >= 2) {
                return false;
            }
        } elseif ($loop == 4) {
            if (count($split) >= 5) {
                return $split[3]." ".$split[4];
            } elseif (count($split) >= 4) {
                return $split[0]." ".$split[3];
            } elseif (count($split) >= 3) {
                return false;
            } elseif (count($split) >= 2) {
                return false;
            }
        } elseif ($loop == 5) {
            if (count($split) >= 5) {
                return $split[2]." ".$split[4];
            } elseif (count($split) >= 4) {
                return false;
            } elseif (count($split) >= 3) {
                return false;
            } elseif (count($split) >= 2) {
                return false;
            }
        }

        return false;
    }

    private function strtoascii($str)
    {
        // Tableau des corespondance
        $str_ascii = [
            'A'  => 'ÀÁÂÃÄÅĀĂǍẠẢẤẦẨẪẬẮẰẲẴẶǺĄ',
            'a'  => 'àáâãäåāăǎạảấầẩẫậắằẳẵặǻą',
            'C'  => 'ÇĆĈĊČ',
            'c'  => 'çćĉċč',
            'D'  => 'ÐĎĐ',
            'd'  => 'ďđ',
            'E'  => 'ÈÉÊËĒĔĖĘĚẸẺẼẾỀỂỄỆ',
            'e'  => 'èéêëēĕėęěẹẻẽếềểễệ',
            'G'  => 'ĜĞĠĢ',
            'g'  => 'ĝğġģ',
            'H'  => 'ĤĦ',
            'h'  => 'ĥħ',
            'I'  => 'ÌÍÎÏĨĪĬĮİǏỈỊ',
            'J'  => 'Ĵ',
            'j'  => 'ĵ',
            'K'  => 'Ķ',
            'k'  => 'ķ',
            'L'  => 'ĹĻĽĿŁ',
            'l'  => 'ĺļľŀł',
            'N'  => 'ÑŃŅŇ',
            'n'  => 'ñńņňŉ',
            'O'  => 'ÒÓÔÕÖØŌŎŐƠǑǾỌỎỐỒỔỖỘỚỜỞỠỢ',
            'o'  => 'òóôõöøōŏőơǒǿọỏốồổỗộớờởỡợð',
            'R'  => 'ŔŖŘ',
            'r'  => 'ŕŗř',
            'S'  => 'ŚŜŞŠ',
            's'  => 'śŝşš',
            'T'  => 'ŢŤŦ',
            't'  => 'ţťŧ',
            'U'  => 'ÙÚÛÜŨŪŬŮŰŲƯǓǕǗǙǛỤỦỨỪỬỮỰ',
            'u'  => 'ùúûüũūŭůűųưǔǖǘǚǜụủứừửữự',
            'W'  => 'ŴẀẂẄ',
            'w'  => 'ŵẁẃẅ',
            'Y'  => 'ÝŶŸỲỸỶỴ',
            'y'  => 'ýÿŷỹỵỷỳ',
            'Z'  => 'ŹŻŽ',
            'z'  => 'źżž',
            // Ligatures
            'AE' => 'Æ',
            'ae' => 'æ',
            'OE' => 'Œ',
            'oe' => 'œ',
        ];

        // Convertion
        foreach ($str_ascii as $k => $v) {
            $str = mb_ereg_replace('['.$v.']', $k, $str);
        }

        return $str;
    }
}