<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\EventListener;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\Routing\RouterInterface;

class VerifyListener
{
    private $session;
    private $router;
    private $request;

    public function __construct(SessionInterface $session, RouterInterface $router, RequestStack $request)
    {
        $this->session = $session;
        $this->router  = $router;
        $this->request = $request;
    }

    public function onKernelRequest(RequestEvent $event)
    {
        if (isset($_SERVER['HTTP_USER_AGENT']))
        {
            if (preg_match('/baidu|dareboost|bingbot|facebookexternalhit|googlebot|-google|ia_archiver|msnbot|naverbot|pingdom|seznambot|slurp|teoma|twitter|yandex|yeti|speed|insights|woobot|ighth|tmetr|eadle|gtmetrix|lighthouse/i', $_SERVER['HTTP_USER_AGENT'])) {
                return;
            }
        }
        
        if (!$event->isMasterRequest() || (preg_match('/media\/cache\/resolve/', $event->getRequest()->getRequestUri()))) {
            return;
        }
        
        $referer  = $this->request->getCurrentRequest()->headers->get('referer');
        $baseUrl  = $this->request->getCurrentRequest()->getSchemeAndHttpHost().'/';
        $lastPath = substr($referer, strpos($referer, $baseUrl) + strlen($baseUrl));
        if (!$this->session->get('verify') && !$this->session->get('referer')) {

            $this->session->set('referer', $this->request->getCurrentRequest()->getSchemeAndHttpHost() . $this->request->getCurrentRequest()->getPathInfo());
        }
        if (preg_match("/-age$/i", $lastPath) && $this->request->getCurrentRequest()->getMethod() === Request::METHOD_POST && !$this->session->get('verify')) {

            $this->session->set('verify', true);
        }

        if ($this->session->get('referer') && ($this->session->get('verify') === true) && $this->request->getCurrentRequest()->getMethod() === Request::METHOD_POST) {

            $referer  = $this->session->get('referer');
            $this->session->remove('referer');
            if (preg_match("/-age$/i", $referer)){
                $referer = $this->request->getCurrentRequest()->getSchemeAndHttpHost();
            }

            $response = new RedirectResponse($referer);
            $event->setResponse($response);
        }


        if ($event->getRequest()->attributes->get('_route') != 'verify' && (!preg_match('/Controller\\\\Admin/', $event->getRequest()->attributes->get('_controller'))) && (!preg_match('/Controller\\\\Site\\\\MethodPaymentController/', $event->getRequest()->attributes->get('_controller'))) &&
            ((strpos($this->request->getCurrentRequest()->getPathInfo(), 'request') != 1)) && (strpos($this->request->getCurrentRequest()->getPathInfo(), '.well-known') != 1)
            && (strpos($this->request->getCurrentRequest()->getPathInfo(), '_wdt') != 1) && (strpos($this->request->getCurrentRequest()->getPathInfo(), '_profiler') != 1) && (!preg_match('/utm_campaign/', $event->getRequest()->getRequestUri()))) {
            if (!$this->session->get('verify')) {
                $response = new RedirectResponse($this->router->generate('verify'));
                $event->setResponse($response);
            }
        }
    }
}
