<?php

declare(strict_types=1);

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler\CarrierProviderPass;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler\PaymentMethodPass;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler\PaymentProviderPass;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler\SocialNetworkNetworkPass;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler\SocialNetworkProviderPass;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

final class CpCreationVitiCoreBundle extends Bundle
{
    /**
     * {@inheritdoc}
     */
    public function build(ContainerBuilder $container)
    {
        parent::build($container);
        $container->addCompilerPass(new PaymentMethodPass());
        $container->addCompilerPass(new PaymentProviderPass());

        $container->addCompilerPass(new SocialNetworkNetworkPass());
        $container->addCompilerPass(new SocialNetworkProviderPass());

        $container->addCompilerPass(new CarrierProviderPass());
    }
}
