<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Media\Model\Media;
use CpCreation\VitiCore\Media\Repository\MediaRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class MediaController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/medias")
 */
class MediaController extends AbstractController
{

    private $mediaRepository;

    public function __construct(MediaRepository $mediaRepository)
    {
        $this->mediaRepository = $mediaRepository;
    }

    /**
     * @param Media $media
     * @Route("/{id}/delete", name="media_delete",  options={"expose"=true})
     *
     * @return JsonResponse
     */
    public function deleteAction(Media $media)
    {
        $this->mediaRepository->delete($media);

        return new JsonResponse(
            [
                'message'      => '',
            ], 200
        );
    }

}