<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Gite\Model;

use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Image;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class GiteImage
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Gite\Repository\GiteImageRepository")
 * @ORM\Table(name="gite_gite_image")
 * @ORM\HasLifecycleCallbacks()
 */
class GiteImage implements HasTimestamp, HasImage
{
    use Timestamp, Image;

    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Gite\Model\Gite", inversedBy="images")
     * @ORM\JoinColumn(name="gite_id", referencedColumnName="id", onDelete="cascade")
     * @Gedmo\SortableGroup()
     *
     * @var Gite
     */
    private $gite;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Gite
     */
    public function getGite(): ?Gite
    {
        return $this->gite;
    }

    /**
     * @param Gite $gite
     */
    public function setGite(Gite $gite = null): void
    {
        $this->gite = $gite;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position = null)
    {
        $this->position = $position;
    }

    /**
     * @param \Symfony\Component\Validator\Context\ExecutionContextInterface $context
     * @Assert\Callback()
     */
    public function validate(ExecutionContextInterface $context)
    {
        if (!$this->getImage()) {
            $message = 'Veuillez ajouter une image';
            $context->buildViolation($message)
                    ->atPath("image.file")
                    ->addViolation();
        }
    }
}