<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Twig;

use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class CookiePriceCodeConvertExtension extends AbstractExtension
{

    private $productPriceGroupRepository;
    private $productPriceCodeRepository;

    public function __construct(ProductPriceGroupRepository $productPriceGroupRepository, ProductPriceCodeRepository $productPriceCodeRepository)
    {
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productPriceCodeRepository = $productPriceCodeRepository;
    }

    public function getFilters()
    {
        return [
            new TwigFilter('convert_id_to_name', [$this, 'ConvertIdToNameFilter']),
            new TwigFilter('get_ht_or_ttc', [$this, 'getHtOrTTCFilter']),
        ];
    }

    public function ConvertIdToNameFilter($id)
    {
        $priceCode = $this->productPriceCodeRepository->findOneBy(['id' => $id]);
        if ($priceCode) {

            return $priceCode->getCode();
        }

        return null;
    }

    public function getHtOrTTCFilter($id)
    {
        $priceGroup = $this->productPriceGroupRepository->findOneBy(['id' => $id]);
        if ($priceGroup->isViewHT()) {
            return 'HT';
        }

        return 'TTC';
    }
}
