<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\ShippingAutoSup;
use Doctrine\Persistence\ManagerRegistry;

class ShippingAutoSupRepository extends BaseRepository
{
    /**
     * ShippingAutoRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShippingAutoSup::class);
    }
    /**
     * @return mixed
     */
    public function findOrder()
    {
        $qb = $this
            ->createQueryBuilder('sa')
            ->addOrderBy('sa.county')
            ->addOrderBy('sa.postal')
            ->addOrderBy('sa.country')
            ->where('sa.verification = TRUE')
            ->getQuery()
            ->getResult();

        return $qb;
    }

    public function findCheckFalse()
    {
        $qb = $this
            ->createQueryBuilder('sa')
            ->addOrderBy('sa.county')
            ->addOrderBy('sa.postal')
            ->addOrderBy('sa.country')
            ->where('sa.verification = FALSE')
            ->getQuery()
            ->getResult();

        return $qb;
    }
}
