<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\ShippingAuto;
use Doctrine\Persistence\ManagerRegistry;

class ShippingAutoRepository extends BaseRepository
{
    /**
     * ShippingAutoRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShippingAuto::class);
    }

    /**
     * @param int    $qty
     * @param string $county
     * @param string $country
     * @param bool $hM
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByQuantityAndByCountyAndByCountry(int $qty, string $county, string $country, bool $hM = false)
    {
        $qb = $this
            ->createQueryBuilder('sa')
            ->andwhere('sa.qtyOf < :qty')
            ->andwhere('sa.qtyAt >= :qty')
            ->andwhere('sa.county = :county')
            ->andwhere('sa.country = :country')
            ->andWhere('sa.hM = :hM')
            ->setParameter('qty', $qty)
            ->setParameter('county', $county)
            ->setParameter('country', $country)
            ->setParameter('hM', $hM)
            ->getQuery()
            ->setMaxResults(1)
            ->getOneOrNullResult();

        return $qb;
    }

    /**
     * @param int    $qty
     * @param string $country
     * @param bool   $hM
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByQuantityAndByCountry(int $qty, string $country, bool $hM = false)
    {
        $qb = $this
            ->createQueryBuilder('sa')
            ->andwhere('sa.qtyOf < :qty')
            ->andwhere('sa.qtyAt >= :qty')
            ->andwhere('sa.country = :country')
            ->andWhere('sa.hM = :hM')
            ->setParameter('qty', $qty)
            ->setParameter('country', $country)
            ->setParameter('hM', $hM)
            ->getQuery()
            ->setMaxResults(1)
            ->getOneOrNullResult();

        return $qb;
    }

    /**
     * @return mixed
     */
    public function findOrder()
    {
        $qb = $this
            ->createQueryBuilder('sa')
            ->addOrderBy('sa.county')
            ->addOrderBy('sa.qtyAt')
            ->getQuery()
            ->getResult();

        return $qb;
    }
}
