<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use CpCreation\VitiCore\Event\Model\EventImage;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShopConfigDisableCountry
 *
 * @ORM\Table(name="shop_shop_config_disable_country")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShopConfigDisableCountryRepository")
 */
class ShopConfigDisableCountry implements HasTimestamp, HasTranslatable
{
    use Translatable, Timestamp;
    
       /**
     * @Assert\Valid
     * @ORM\OneToMany(targetEntity="CpCreation\VitiCore\Shop\Model\Translation\ShopConfigDisableCountryTranslation", mappedBy="translatable", cascade={"persist","remove","merge"}, indexBy="locale", orphanRemoval="true")
     *
     * @var TranslationInterface[]|Collection
     */
    protected $translations;
    
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="string")
     *
     * @var string
     */
    private $country;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Shop\Model\ShopConfig", inversedBy="disableCountries")
     *
     * @var ShopConfig
     */
    private $config;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    /**
     * @return ShopConfig
     */
    public function getConfig(): ShopConfig
    {
        return $this->config;
    }

    /**
     * @param ShopConfig $config
     */
    public function setConfig(ShopConfig $config): void
    {
        $this->config = $config;
    }
}
