<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model\Payment;

use Symfony\Component\Validator\Constraints as Assert;

class Sherlock2
{
    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $merchantId;

    /**
     * @var boolean
     */
    private $production;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $secretKey;

    /**
     * @Assert\NotBlank
     * Version de la clé
     *
     * @var string
     */
    private $keyVersion;

    public function __construct()
    {}

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getMerchantId(): string
    {
        return $this->merchantId;
    }

    /**
     * @param string $merchantId
     */
    public function setMerchantId(string $merchantId): void
    {
        $this->merchantId = $merchantId;
    }

    /**
     * @return string
     */
    public function getSecretKey(): string
    {
        return $this->secretKey;
    }

    /**
     * @param string $secretKey
     */
    public function setSecretKey(string $secretKey): void
    {
        $this->secretKey = $secretKey;
    }

    /**
     * @return string
     */
    public function getKeyVersion(): string
    {
        return $this->keyVersion;
    }

    /**
     * @param string $keyVersion
     */
    public function setKeyVersion(string $keyVersion): void
    {
        $this->keyVersion = $keyVersion;
    }

    /**
     * @return bool
     */
    public function isProduction(): bool
    {
        return $this->production;
    }

    /**
     * @param bool production
     */
    public function setProduction(bool $production): void
    {
        $this->production = $production;
    }
}
