<?php
/**
 * @author Colinet Julien
 */
namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Validator\Constraints;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\LocaleProvider;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class TranslationValidator extends ConstraintValidator
{
    private $localeProvider;
    /**
     * TranslationValidator constructor.
     * @param LocaleProvider $localeProvider
     */
    public function __construct(LocaleProvider $localeProvider)
    {
        $this->localeProvider = $localeProvider;

    }

    public function validate($value, Constraint $constraint)
    {
        foreach ($this->localeProvider->getLocales() as $locale)
        {
            if(!$value->containsKey($locale))
            {
                $this->context->buildViolation($constraint->message)
                              ->setParameter('{{ string }}', $locale)
                              ->addViolation();
            }
        }
    }
}
