<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Carrier\CarrierProviderInterface;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;

class CarrierProviderManager
{
    private $providers = [] ;

    /**
     * @param CarrierProviderInterface $provider
     */
    public function addProvider(CarrierProviderInterface $provider)
    {
        $this->providers[] = $provider;
    }

    /**
     * @param ShippingConfig $config
     * @return mixed
     * @throws \Exception
     */
    public function createProviderManager(ShippingConfig $config)
    {
        foreach ($this->providers as $item)
        {
            if ($item->getCarrier() === $config->getCarrier()){
                return $item->setData($config);
            }
        }

        throw new \Exception("Pas de provider de transporteur trouvé");

    }
}
