<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\DataTransformer\TransformDateAtToIntAdditional;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\DataTransformer\TransformDateOfToIntAdditional;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Model\ProductType as ModelProductType;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\ShippingAdditional;
use CpCreation\VitiCore\Shop\Model\ShippingAdditionalManual;
use CpCreation\VitiCore\Shop\Model\ShippingCounty;
use CpCreation\VitiCore\Shop\Model\ShippingZone;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShippingAdditionalManualType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('qtyOf', IntegerType::class, ['label' => 'De (>)', 'required' => true])
            ->add('qtyAt', IntegerType::class, ['label' => 'A (<=)', 'required' => true])
            ->add('dateOf', DateTimeType::class, [
                'required' => false,
                'label'    => 'Début de la période pour prise en compte du supplément',
                'input'    => 'datetime',
                'format'   => 'yyyy-MM-dd',
                'html5'    => false,
                'widget'   => 'single_text',
                'attr'     => [
                    'class' => 'datetimepicker',

                ],
            ])
            ->add(
                'types', TranslatedEntityType::class,
                [
                    'class'                => ModelProductType::class,
                    'translation_property' => 'name',
                    'choice_label'         => function (ProductType $type) {
                        if ($type->getInfo()) {
                            return $type->getName().'('.$type->getInfo().')';
                        } else {
                            return $type->getName();
                        }

                    },
                    'label'                => 'Type(s) pris en compte',
                    'multiple'             => true,
                    'required'             => true,
                    'attr'                 => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add('dateAt', DateTimeType::class, [
                'required' => false,
                'label'    => 'Fin de la période pour prise en compte du supplément',
                'input'    => 'datetime',
                'format'   => 'yyyy-MM-dd',
                'html5'    => false,
                'widget'   => 'single_text',
                'attr'     => [
                    'class' => 'datetimepicker',

                ],
            ])
            ->add(
                'ht', CheckboxType::class, ['label' => 'HT ?', 'required' => false]
            )
            ->add(
                'groups', EntityType::class,
                [
                    'class'         => ProductPriceGroup::class,
                    'query_builder' => function (ProductPriceGroupRepository $er) {
                        return $er->findByNameOrderAdminQuery();
                    },
                    'choice_label'  => 'name',
                    'label'         => 'Groupes de prix',
                    'multiple'      => true,
                    'required'      => true,
                    'attr'          => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'zones', EntityType::class,
                [
                    'class'        => ShippingZone::class,
                    'choice_label' => 'name',
                    'label'        => 'Zone(s)',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'packagePrice', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Forfait (HT si marge global coché ou TTC)',
                    'required' => false,
                ]
            )
            ->add(
                'bottlePrice', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'Par bouteille (HT si marge global coché ou TTC)',
                    'required' => false,
                ]
            );
        $builder->get('dateOf')
                ->addModelTransformer(new TransformDateOfToIntAdditional());
        $builder->get('dateAt')
                ->addModelTransformer(new TransformDateAtToIntAdditional());
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShippingAdditionalManual::class,
            ]
        );
    }
}
